<?php
/**
 * theme customisation and functions
 *
 * @package    stockist-mini
 */

$productive_stockist_mini_theme_version_obj = wp_get_theme();
$productive_stockist_mini_theme_version = $productive_stockist_mini_theme_version_obj->get( 'Version' );

/**
 * Method productive_stockist_mini_scripts
 */
function productive_stockist_mini_scripts() {

    global $productive_stockist_mini_theme_version;
    
    wp_enqueue_style( 'productive_child_theme_wp_css_style', get_stylesheet_uri(), array(), $productive_stockist_mini_theme_version );
    wp_style_add_data( 'productive_child_theme_wp_css_style', 'rtl', 'replace' );
    
    wp_enqueue_script( 'stockist-mini-js', get_theme_file_uri() . '/assets/js/child-theme.js', array(), $productive_stockist_mini_theme_version, true );

}
if ( !is_admin() ) {
    add_action( 'wp_enqueue_scripts', 'productive_stockist_mini_scripts', 82 );
}

/**
 * Method enable featured image.
 */
function productive_stockist_mini_setup_theme() {
    
    // Add support for WP to manage rendering of <title> tag in html document head
    add_theme_support( 'title-tag' );
    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );
    // Add support for Post Thumbnails on posts and pages.
    add_theme_support('post-thumbnails');
    // Add theme support for selective refresh for widgets.
    add_theme_support( 'customize-selective-refresh-widgets' );
    // Add support for Block Styles.
    add_theme_support('wp-block-styles');
    // Add support for full and wide align images.
    add_theme_support( 'align-wide' );
    // Add support for editor styles.
    add_theme_support( 'editor-styles' );
    // Enqueue editor styles.
    add_editor_style( './assets/css/style-editor.css' );
    // Add support for responsive embedded content.
    add_theme_support('responsive-embeds');
    // Upgrades widget areas to allow using blocks alongside widgets
    add_theme_support('widgets-block-editor');
    // Set core markup for search form, comment form, comments etc to output valid HTML5.
    $args = array(
        'style',
        'gallery',
        'caption',
        'script',
        'search-form',
        'comment-form',
        'comment-list',
        'navigation-widgets',
    );
    add_theme_support( 'html5', $args );
    
    add_theme_support( 'editor-styles' );
    load_child_theme_textdomain( 'stockist', get_stylesheet_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'productive_stockist_mini_setup_theme', 99 );


function productive_stockist_mini_get_theme_home_template() {
?>
    <main class="site-body-container main-container" id="site-content">
    <?php
        $is_homepage_banner_enabled = productive_stockist_is_homepage_banner_enable();
        if ( $is_homepage_banner_enabled ) {
            productive_stockist_render_homepage_hero();
        }
        if( productive_global_is_woocommerce_active() ) {
            do_action('productive_global_render_home_section_featured');

            do_action('productive_global_render_home_section_latest');
        }
        productive_stockist_render_content_archive_item_blog( 1, 0, 0, 1, 1 );
    ?>
    </main>
<?php 
}

function productive_stockist_mini_theme_dash_required_content() {
    return esc_html__( 'Theme Dashboard', 'stockist-mini' );
}
